// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

const int MAXN = 20;
const int inf = 1e9;

bool e[MAXN][MAXN];
int v[MAXN][MAXN];
int f[1<<MAXN];
int r[1<<MAXN];
int a[MAXN][MAXN];
int n;

int main(void) {
  int t;
  scanf("%d", &t);
  while (t--) {
    scanf("%d", &n);
    REP(i, n) REP(j, n) scanf("%d", &a[i][j]);
    
    REP(i, n) REP(j, n) {
      e[i][j] = false;
      int val = a[i][j];
      if (val == -1) val = 100;
      
      bool ok = val > 0;
      REP(k, n) {
        if (k != i) ok &= a[k][j] < val;
        if (k != j) ok &= a[i][k] < val;
      }
      if (ok) {
        e[i][j] = true;
        v[i][j] = val;
      }
    }

    REP(s, 1<<n) f[s] = -inf;
    f[0] = 0;
    
    REP(s, 1<<n) 
      if (f[s] >= 0) {
        int i = 0;
        REP(j, n)
          if (s&(1<<j)) i++;
        
        REP(j, n)
          if (!(s&(1<<j))) 
            if (e[i][j] && f[s] + v[i][j] > f[s | (1<<j)]) {
              f[s | (1<<j)] = f[s] + v[i][j];
              r[s | (1<<j)] = j;
            }
      }

    if (f[(1<<n)-1] == -inf) {
      puts("-1");
      continue;
    }
    
    int s = (1<<n) - 1;
    for (int i = n-1; i >= 0; --i) {
      int j = r[s];
      if (a[i][j] == -1) a[i][j] = 100;
      s ^= 1<<j;
    }
    
    REP(i, n) REP(j, n)
      if (a[i][j] == -1) a[i][j] = 0;
    REP(i, n) REP(j, n) printf("%d%c", a[i][j], " \n"[j + 1 == n]);
  }

  return 0;
}
